<?php
	wp_enqueue_style('wp-iv_directories-bidding-style-101', wp_iv_directories_URLPATH . 'admin/files/css/bidding.css');
	wp_enqueue_style('wp-iv_directories-bidding-style-102', wp_iv_directories_URLPATH . 'admin/files/css/colorbox.css');
	wp_enqueue_script('wp-iv_directories-bidding-script-103', wp_iv_directories_URLPATH . 'admin/files/js/jquery.colorbox-min.js');
	wp_enqueue_style('template_inline_css', wp_iv_directories_URLPATH . 'admin/files/css/inline.css');
	$profile_url=get_permalink();
	global $current_user;
	global $wpdb;
	$user = $current_user->ID;
	$message='';
	if(isset($_GET['delete_id']))  {
		$post_id=sanitize_text_field($_GET['delete_id']);
		$post_edit = get_post($post_id);
		if($post_edit->post_author==$current_user->ID){
			wp_delete_post($post_id);
			delete_post_meta($post_id,true);
			$message= esc_html__( 'Deleted Successfully', 'ivdirectories' );
		}
	}
	wp_enqueue_style('jquery.dataTables', wp_iv_directories_URLPATH . 'admin/files/css/jquery.dataTables.css');
	wp_enqueue_script('jquery.dataTables', wp_iv_directories_URLPATH . 'admin/files/js/jquery.dataTables.js');
?>
<div class="profile-content">
	<div class="portlet light">
		<div class="portlet-title tabbable-line clearfix">
			<div class="caption caption-md">
				<span class="caption-subject">
					<?php
						esc_html_e('My Favorites','ivdirectories')
					?></span>
			</div>
		</div>
		<div class="portlet-body">
			<div class="">
				<div class="col-lg-12 col-sm-12">
					<div class="srchresultwrapper">
						<?php
							$default_post_type = array();
							$postkey= array();
							$post_set=get_option('_iv_directory_url_postype' );
							if($post_set!=""){
								$default_fields=get_option('_iv_directory_url_postype' );
								}else{
								$default_fields['hotel']='Hotel';
								$default_fields['restaurant']='Restaurant';
								$default_fields['bar']='Bar';	
							}
							foreach($default_fields as $key => $value)
							{
								$postkey[] = $key;
							}
							$post_type = join("','",$postkey);
							$favorites=get_user_meta($user,'_dir_favorites', true);
							$favorites_a = array();
							$favorites_a = explode(",", $favorites);
							$ids = array();
							foreach($favorites_a as $key => $value)
							{
								if(trim($value)!=''){
									$ids[] = $value;
								}
							}
							if(is_array($ids)){
								foreach ($ids as $fav_one) {
									$fav_one=trim($fav_one);
								?>
								<div class="srchresult" id="main_<?php echo esc_html($fav_one);?>">
									<div class="col-lg-3 col-sm-3 col-xs-3">
										<div class="picwrapper">
											<?php $feature_image = wp_get_attachment_image_src( get_post_thumbnail_id( $fav_one), 'medium' );
												if(isset($feature_image[0]) AND $feature_image[0]!=""){ ?>
												<a href="<?php echo get_permalink($fav_one); ?>" > <img title="image"   src="<?php  echo esc_html($feature_image[0]); ?>"></a>
												<?php
												}
											?>
										</div>
									</div>
									<div class="col-lg-9 col-sm-9 col-xs-9">
										<div class="rightflaot">
											<button type="button" class="btn btn-default btn-xs" onclick="close_his(<?php echo esc_html($fav_one);?>);return false;">X</button>
										</div>
										<h5 class="listing-info" ><a href="<?php echo get_permalink($fav_one); ?>"><?php echo get_the_title ($fav_one); ?></a></h5>
										<p class="desc">  </p>
										<?php esc_html_e('Address :','ivdirectories');  echo get_post_meta($fav_one,'address',true); ?>   <br />
										<div class="rightflaot">
											<div id="update_message"></div>
											<input type="button"  onclick="load_note_dir(<?php echo esc_html($fav_one); ?>,'<?php echo get_post_meta($fav_one,'_note_'.$user,true); ?>');" value="Add note"  class="btn btn-default btn-sm"/>
											<a class='btn btn-primary btn-sm popup-contact' href="<?php echo admin_url('admin-ajax.php').'?action=iv_directories_contact_popup&dir-id='.$fav_one; ?>">
												<?php esc_html_e('Contact','ivdirectories'); ?>
											</a>
										</div>
									</div>
									<div class="col-lg-12 col-sm-12 col-xs-12">
										<div class="col-lg-12 col-sm- col-xs-12" id="dir_<?php echo trim($fav_one); ?>">
											<p>
												<?php
													if(get_post_meta($fav_one,'_note_'.get_current_user_id(),true)!=''){
													?>
													<div class=" row">
														<strong>Note: </strong> <?php echo get_post_meta($fav_one,'_note_'.get_current_user_id(),true); ?>
													</div>
													<?php
													}
												?>
											</p>
										</div>
									</div>
									<div class="clear">&nbsp;</div>
								</div>
								<?php
								}
								}else{
								esc_html_e('No data available','ivdirectories');
							}
							wp_reset_query();
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>